import {
  Controller, ForbiddenException, Get, HttpException, Param, Post, Query, UseInterceptors
} from '@nestjs/common';

import { DataResponse } from 'src/core';

import { FileUploaded } from '../decorators/file.decorator';
import { FileUploadInterceptor } from '../interceptors';
import { IMulterFileUpload } from '../interfaces';
import { verifyHash } from '../lib/file-utils';
import { FileService } from '../services';

@Controller('/files')
export class FileController {
  constructor(
    private readonly fileService: FileService
  ) { }

  @Post('/:fileId/upload')
  @UseInterceptors(
    FileUploadInterceptor('file')
  )
  async uploadMedia(
    @Param('fileId') fileId: string,
    @FileUploaded() file: IMulterFileUpload
  ) {
    if (!file) throw new HttpException('Missing uploaded file', 400);

    await this.fileService.processFileUpload(fileId, file);
    return DataResponse.ok({
      fileId
    });
  }

  // TODO - implement me
  @Get('/auth/check')
  async checkAuth(
    @Query() query: Record<string, string>
  ) {
    if (!query.hash) throw new ForbiddenException();
    if (!verifyHash(query.hash)) throw new ForbiddenException();
    // TODO - implement me
    return DataResponse.ok(true);
  }
}
