import { join } from 'path';

export const FILE_STATUS = {
  UPLOADED: 'uploaded',
  PENDING_UPLOAD: 'pending_upload',
  PROCESSING: 'processing',
  PROCESSED: 'processed',
  ERROR: 'error'
};

export const FILE_UPLOADED_EVENT = 'file_uploaded';

export const MAX_UPLOAD_SIZE_IMAGE_IN_MB = 20;
export const MAX_UPLOAD_SIZE_VIDEO_IN_MB = 2048;
export const MAX_UPLOAD_SIZE_DOCUMENT_IN_MB = 1024;

/**
 * compress image quality to jpg format at 70%
 */
export const COMPRESS_IMAGE_QUALITY = 70;

export const THUMBNAIL_WIDTH = 350;

export const FILE_MEDIA_CONVERT_CHANNEL = 'FILE_MEDIA_CONVERT_CHANNEL';
export const HANDLE_MEDIA_CONVERT_TOPIC = 'HANDLE_MEDIA_CONVERT_TOPIC';

export const FILE_UPLOAD_BASE_URL = process.env.FILE_UPLOAD_BASE_URL || 'http://localhost:8080/files/{fileId}/upload';

/**
 * public folder to get files, etc...
 */
export const PUBLIC_DIR = join(__dirname, '..', '..', 'public');

export const UPLOAD_DIR = join(__dirname, '..', '..', 'public', 'upload');
