import { Expose, Transform } from 'class-transformer';
import { ObjectId } from 'mongodb';

import { removeNullFromArray } from 'src/core';
import { FileDto } from 'src/file-module/dtos';
import { ReactionInfo } from 'src/interfaces';

import { CategoryDto } from './category.dto';
import { PerformerDto } from './performer.dto';
import { ProfileDto } from './profile.dto';

export class VideoDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  @Expose()
  title: string;

  @Expose()
  slug: string;

  @Expose()
  description: string;

  @Expose()
  seoTitle: string;

  @Expose()
  seoKeywords: string;

  @Expose()
  seoDesc: string;

  @Expose()
  status: string;

  @Expose()
  url: string;

  @Expose()
  thumbnails: string[];

  @Expose()
  embeddedCode: string;

  @Expose()
  duration: number;

  @Expose()
  @Transform(({ obj }) => removeNullFromArray(obj.performerIds))
  performerIds: string[];

  @Expose()
  tags: string[];

  @Expose()
  @Transform(({ obj }) => removeNullFromArray(obj.categoryIds))
  categoryIds: ObjectId[];

  @Expose()
  @Transform(({ obj }) => obj.createdBy)
  createdBy: ObjectId;

  @Expose()
  updatedAt: Date;

  @Expose()
  createdAt: Date;

  @Expose()
  price: number;

  @Expose()
  stats: Record<string, any>;

  @Expose()
  video: FileDto;

  @Expose()
  videos: Partial<FileDto>[];

  @Expose()
  isLiked: boolean;

  @Expose()
  isBookmarked: boolean;

  @Expose()
  categories: CategoryDto[];

  @Expose()
  performers: PerformerDto[];

  @Expose()
  convertStatus: string;

  @Expose()
  isHD: boolean;

  @Expose()
  verified: boolean;

  @Expose({ groups: ['admin', 'owner'] })
  fileId: string;

  @Expose()
  isPurchased: boolean;

  @Expose()
  creator: ProfileDto;

  public setMainVideo(file: FileDto) {
    this.video = file;
  }

  public setReactionInfo(info: ReactionInfo) {
    Object.assign(this, info);
  }

  public setCreator(profile: ProfileDto) {
    this.creator = profile;
  }
}
