import { Expose, Transform } from 'class-transformer';
import { ObjectId } from 'mongodb';

export class TagDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  @Expose()
  name: string;

  @Expose()
  key: string;

  @Expose()
  updatedAt: Date;

  @Expose()
  createdAt: Date;

  public toPublicResponse() {
    return ({
      _id: this._id,
      name: this.name,
      key: this.key
    });
  }
}
