import { Expose, Transform } from 'class-transformer';
import { ObjectId } from 'mongodb';

export class SettingDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  @Expose()
  key: string;

  @Expose()
  value: any;

  @Expose()
  name: string;

  @Expose()
  description: string;

  @Expose()
  group: string;

  @Expose()
  public: boolean;

  @Expose()
  type: string;

  @Expose()
  visible: boolean;

  @Expose()
  autoload: boolean;

  @Expose()
  meta: Record<string, any>;

  @Expose()
  createdAt: Date;

  @Expose()
  updatedAt: Date;

  @Expose()
  extra: string;

  public getValue() {
    if (this.type === 'text' && !this.value) {
      return '';
    }

    return this.value;
  }
}
