import { Expose, Transform } from 'class-transformer';
import { ObjectId } from 'mongodb';

import { ProfileDto } from './profile.dto';

export class ReactionDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  source: string;

  @Expose()
  action: string;

  @Expose()
  @Transform(({ obj }) => obj.objectId)
  objectId: ObjectId;

  @Expose()
  objectType: string;

  @Expose()
  createdBy: string | ObjectId;

  @Expose()
  createdAt: Date;

  @Expose()
  updatedAt: Date;

  @Expose()
  objectInfo: Record<string, any>;

  creator: ProfileDto;
}
