import { Expose, Transform } from 'class-transformer';
import { ObjectId } from 'mongodb';

export class ProfileDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  @Expose()
  @Transform(({ obj }) => obj.name || [obj.firstName, obj.lastName].filter((n) => !!n).join(' '))
  name: string;

  @Expose()
  firstName: string;

  @Expose()
  lastName: string;

  @Expose()
  username: string;

  @Expose()
  email: string;

  @Expose()
  gender: string;

  @Expose()
  status: string;

  @Expose()
  avatar: string;

  @Expose()
  balance: number;

  @Expose()
  bio: string;

  @Expose()
  phone: string;

  @Expose()
  phoneCode: string;

  @Expose()
  city: string;

  @Expose()
  state: string;

  @Expose()
  address: string;

  @Expose()
  languages: string[];

  @Expose()
  categories: string[];

  @Expose()
  hashTags: string[];

  @Expose()
  country: string;

  @Expose()
  roles: string[];

  @Expose()
  verifiedEmail: boolean;

  @Expose()
  verifiedAccount: boolean;

  @Expose()
  verifiedDocument: boolean;

  @Expose()
  createdAt: Date;

  @Expose()
  updatedAt: Date;

  @Expose()
  dateOfBirth: Date;

  public isAdmin(): boolean {
    return this.roles.includes('admin');
  }
}
