import { Expose, Transform, Type } from 'class-transformer';
import { ObjectId } from 'mongodb';

import { CategoryDto } from 'src/dtos';

export class PostDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  @Expose()
  title: string;

  @Expose()
  slug: string;

  @Expose()
  content: string;

  @Expose()
  seoTitle: string;

  @Expose()
  seoKeywords: string;

  @Expose()
  seoDesc: string;

  @Expose()
  status: string;

  @Expose()
  @Transform(({ obj }) => obj.categoryIds)
  categoryIds: string[];

  @Expose()
  updatedAt: Date;

  @Expose()
  createdAt: Date;

  @Expose()
  @Type(() => CategoryDto)
  categories: CategoryDto;
}
