import { Expose, Transform } from 'class-transformer';
import { ObjectId } from 'mongodb';

export class PerformerDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  @Expose()
  name: string;

  @Expose()
  gender: string;

  @Expose()
  bio: string;

  @Expose()
  updatedAt: Date;

  @Expose()
  createdAt: Date;

  @Expose()
  avatarId: string;

  @Expose()
  coverId: string;

  @Expose()
  stats: Record<string, any>;

  avatarUrl: string;

  coverUrl: string;

  isLiked: boolean;

  isBookmarked: boolean;

  isFollowed: boolean;

  @Expose()
  seoTitle: string;

  @Expose()
  seoKeywords: string;

  @Expose()
  seoDesc: string;

  public setAvatarUrl(file: any) {
    this.avatarUrl = file?.url || '';
  }

  public setCoverUrl(file: any) {
    this.coverUrl = file?.url || '';
  }
}
