import { Expose, Transform } from 'class-transformer';
import { ObjectId } from 'mongodb';

export class EmailTemplateDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  @Expose()
  name: string;

  @Expose()
  key: string;

  @Expose()
  description: string;


  @Expose()
  subject: string;

  @Expose()
  content: string;

  @Expose()
  layout: string;

  @Expose()
  updatedAt: Date;

  @Expose()
  createdAt: Date;
}
