import { Expose, Transform } from 'class-transformer';
import { ObjectId } from 'mongodb';

export class ChannelDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  @Expose()
  name: string;

  @Expose()
  slug: string;

  @Expose()
  description: string;

  @Expose()
  updatedAt: Date;

  @Expose()
  createdAt: Date;

  @Expose()
  imageId: string;

  @Expose()
  monthlySubscriptionPrice: number;

  @Expose()
  yearlySubscriptionPrice: number;

  @Expose()
  stats: Record<string, any>;

  imageUrl: string;

  isFollowed: boolean;

  @Expose()
  seoTitle: string;

  @Expose()
  seoKeywords: string;

  @Expose()
  seoDesc: string;

  @Expose()
  totalViews: number;

  @Expose()
  totalVideos: number;

  public setImageUrl(file: any) {
    this.imageUrl = file?.url || '';
  }

  public setTotalVideoView({ totalViews, totalVideos }) {
    this.totalViews = totalViews;
    this.totalVideos = totalVideos;
  }
}
