import { Expose, Transform } from 'class-transformer';
import { ObjectId } from 'mongodb';

import { IPublicFileInfo } from 'src/file-module/interfaces';

export class CategoryDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  @Expose()
  title: string;

  @Expose()
  description: string;

  @Expose()
  slug: string;

  @Expose()
  seoTitle: string;

  @Expose()
  seoDesc: string;

  @Expose()
  seoKeywords: string;

  @Expose()
  posterId: ObjectId;

  @Expose()
  status: string;

  @Expose()
  ordering: Number;

  @Expose()
  group: string;

  @Expose()
  createdAt: Date;

  @Expose()
  updatedAt: Date;

  posterUrl: string;

  public setPosterUrl(file: IPublicFileInfo) {
    this.posterUrl = file?.url || '';
  }
}
