import { Expose, Transform } from 'class-transformer';
import { ObjectId } from 'mongodb';

export class AdDto {
  @Expose()
  @Transform(({ obj }) => obj._id)
  _id: ObjectId;

  @Expose()
  name: string;

  @Expose()
  type: string;

  @Expose()
  adUrl: string;

  @Expose()
  position: string;

  @Expose()
  ordering: number;

  @Expose()
  description: string;

  @Expose()
  status: string;

  @Expose()
  scriptCode: string;

  @Expose()
  updatedAt: Date;

  @Expose()
  createdAt: Date;

  @Expose()
  fileId: string;

  @Expose()
  fileUrl: string;

  // show thumnail for video ad image ad
  @Expose()
  thumbnailUrl: string;

  public setFileUrl(file: any) {
    this.fileUrl = file?.url || '';
  }

  public setThumbnailUrl(file: any) {
    this.thumbnailUrl = file?.thumbnailUrl || '';
  }
}
