import { DynamicModule, Module } from '@nestjs/common';
import IORedis from 'ioredis';

import {
  CORE_QUEUE_MESSAGE_REDIS_CONNECTION, CORE_QUEUE_MODULE_CONFIG_OPTIONS, CoreQueueModuleAsyncConfigOptions, CoreQueueModuleConfigOptions
} from './constants';
import { QueueMessageService } from './queue-message.service';
import { QueueService } from './queue.service';

@Module({})
export class CoreQueueModule {
  static register(options: CoreQueueModuleConfigOptions): DynamicModule {
    const redisConfig = options.redisConfig || {
      host: 'localhost',
      port: 6379,
      db: 0
    } as any;
    const redisQueueConnection = new IORedis({
      ...redisConfig,
      // bull MQ requires this option
      maxRetriesPerRequest: null
    });
    // do not connect redis connection. BullMQ will throw error if it is already connected
    // await redisQueueConnection.connect();
    // TODO - log me

    return {
      module: CoreQueueModule,
      providers: [
        {
          provide: CORE_QUEUE_MODULE_CONFIG_OPTIONS,
          useValue: options
        },
        {
          provide: CORE_QUEUE_MESSAGE_REDIS_CONNECTION,
          useValue: {
            redisQueueConnection,
            redisConfig,
            useRedisCluster: options.useRedisCluster
          }
        },
        QueueMessageService,
        QueueService
      ],
      exports: [
        QueueMessageService,
        QueueService
      ]
    };
  }

  static async registerAsync(options: CoreQueueModuleAsyncConfigOptions): Promise<DynamicModule> {
    // do not connect redis connection. BullMQ will throw error if it is already connected
    // await redisQueueConnection.connect();
    // TODO - log me
    const asyncProviders = {
      inject: options.inject || [],
      provide: CORE_QUEUE_MESSAGE_REDIS_CONNECTION,
      useFactory: async (factoryOptions) => {
        const { redisConfig, ...rests } = await options.useFactory(factoryOptions);
        const redisQueueConnection = new IORedis({
          ...redisConfig,
          // bull MQ requires this option
          maxRetriesPerRequest: null
        });
        return {
          redisQueueConnection,
          redisConfig,
          ...rests
        };
      }
    };

    return {
      module: CoreQueueModule,
      imports: options.imports,
      providers: [
        {
          provide: CORE_QUEUE_MODULE_CONFIG_OPTIONS,
          useValue: options
        },
        asyncProviders,
        QueueMessageService,
        QueueService
      ],
      exports: [
        QueueMessageService,
        QueueService
      ]
    };
  }
}
