import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import * as mongoose from 'mongoose';

@Schema({ collection: 'requestlogs' })
export class RequestLog {
  @Prop()
  path: string;

  @Prop()
  ip: string;

  @Prop({
    type: mongoose.Schema.Types.Mixed
  })
  query: Record<string, any>;

  @Prop({
    type: mongoose.Schema.Types.Mixed
  })
  body: Record<string, any>;

  @Prop({
    type: mongoose.Schema.Types.Mixed
  })
  headers: Record<string, any>;

  @Prop({
    type: mongoose.Schema.Types.Mixed
  })
  authData: Record<string, any>;
}

export const RequestLogSchema = SchemaFactory.createForClass(RequestLog);
export type RequestLogDocument = mongoose.HydratedDocument<RequestLog>;
