import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import * as mongoose from 'mongoose';

@Schema({ collection: 'httpexceptionlogs' })
export class HttpExceptionLog {
  @Prop()
  path: string;

  @Prop()
  ip: string;

  @Prop({
    type: mongoose.Schema.Types.Mixed
  })
  query: Record<string, any>;

  @Prop({
    type: mongoose.Schema.Types.Mixed
  })
  body: Record<string, any>;

  @Prop({
    type: mongoose.Schema.Types.Mixed
  })
  headers: Record<string, any>;

  @Prop({
    type: mongoose.Schema.Types.Mixed
  })
  authData: Record<string, any>;

  @Prop({
    type: mongoose.Schema.Types.Mixed
  })
  error: Record<string, any>;

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;
}

export const HttpExceptionLogSchema = SchemaFactory.createForClass(HttpExceptionLog);
