import {
  HttpCode,
  HttpStatus,
  Controller,
  Get,
  Injectable,
  UseGuards,
  UsePipes,
  ValidationPipe
} from '@nestjs/common';

import { DataResponse } from 'src/core';
import { Roles } from 'src/decorators';
import { RoleGuard } from 'src/guards';
import { StatsService } from 'src/services';

@Injectable()
@Controller('admin/stats')
export class StatsController {
  constructor(private readonly statService: StatsService) { }

  @Get('')
  @HttpCode(HttpStatus.OK)
  @UseGuards(RoleGuard)
  @Roles('admin')
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  public async stats() {
    const stats = await this.statService.stats();
    return DataResponse.ok(stats);
  }
}
