import {
  HttpCode,
  HttpStatus,
  Controller,
  Get,
  Injectable
} from '@nestjs/common';

import { DataResponse } from 'src/core';
import { LanguageService } from 'src/services';

@Injectable()
@Controller('languages')
export class LanguageController {
  constructor(private readonly languageService: LanguageService) { }

  @Get('list')
  @HttpCode(HttpStatus.OK)
  list() {
    return DataResponse.ok(this.languageService.getList());
  }
}
