import {
  Controller, Get, Param, Query, UsePipes, ValidationPipe
} from '@nestjs/common';

import { DataResponse } from 'src/core';
import { TagSearchPayload } from 'src/payloads';
import { TagSearchService, TagService } from 'src/services';

@Controller('/tags')
export class TagController {
  constructor(
    private readonly tagSearchService: TagSearchService,
    private readonly tagService: TagService
  ) { }

  @Get('/search')
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  public async search(@Query() payload: TagSearchPayload) {
    return DataResponse.ok(await this.tagSearchService.search(payload));
  }

  @Get('/:id')
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  public async getDetails(@Param('id') id: string) {
    return DataResponse.ok((await this.tagService.getDetails(id)).toPublicResponse());
  }
}
