import {
  Controller, Get, UseGuards, UsePipes, ValidationPipe
} from '@nestjs/common';

import { DataResponse } from 'src/core';
import { CurrentUser } from 'src/decorators';
import { AuthGuard } from 'src/guards';
import { ProfileService } from 'src/services';

@Controller('/profiles')
export class ProfileController {
  constructor(
    private readonly profileService: ProfileService
  ) { }

  @Get('/me')
  @UseGuards(AuthGuard)
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  async getMyProfile(
    @CurrentUser() user: any
  ) {
    const profile = await this.profileService.findById(user._id);
    // TODO - transfer to DTO and get public
    return DataResponse.ok(profile);
  }
}
