import {
  Controller, Post, UseGuards, UsePipes, ValidationPipe
} from '@nestjs/common';

import { DataResponse } from 'src/core';
import { CurrentUser } from 'src/decorators';
import { AuthGuard } from 'src/guards';
import { AvatarService } from 'src/services';

@Controller('/profiles/avatar')
export class AvatarController {
  constructor(
    private readonly avatarService: AvatarService
  ) { }

  /**
   * get upload URL
   * @param user UserDto
   */
  @Post('/upload-url')
  @UseGuards(AuthGuard)
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  async updateCurrentUserAvatar(
    @CurrentUser() user: any
  ) {
    const res = await this.avatarService.getDirectUploadUrl(user._id);
    return DataResponse.ok(res);
  }
}
