import {
  Controller, Get, Param, Query, UsePipes, ValidationPipe
} from '@nestjs/common';

import { DataResponse } from 'src/core';
import { PostSearchPayload } from 'src/payloads';
import { PostSearchService, PostService } from 'src/services';

@Controller('/posts')
export class PostController {
  constructor(
    private readonly postSearchService: PostSearchService,
    private readonly postService: PostService
  ) { }

  @Get('/search')
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  public async search(@Query() payload: PostSearchPayload) {
    return DataResponse.ok(await this.postSearchService.search(payload));
  }

  @Get('/:id')
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  public async getDetails(@Param('id') id: string) {
    return DataResponse.ok(await this.postService.getDetails(id));
  }
}
