import {
  Controller, Get, UsePipes, ValidationPipe
} from '@nestjs/common';

import { DataResponse } from 'src/core';
import { PostSearchService } from 'src/services';

@Controller('/menus')
export class MenuController {
  constructor(
    private readonly postSearchService: PostSearchService
  ) { }

  @Get('/')
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  public async getMenus() {
    return DataResponse.ok(await this.postSearchService.getMenus());
  }
}
