import {
  Controller, Get, Param, Query, UsePipes, ValidationPipe
} from '@nestjs/common';

import { DataResponse } from 'src/core';
import { CategorySearchRequest } from 'src/payloads';
import { CategorySearchService, CategoryService } from 'src/services';

@Controller('/categories')
export class CategoryController {
  constructor(
    private readonly categorySearchService: CategorySearchService,
    private readonly categoryService: CategoryService
  ) { }

  @Get('/search')
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  public async search(@Query() payload: CategorySearchRequest) {
    return DataResponse.ok(await this.categorySearchService.search(payload));
  }

  @Get('/:id/view')
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  public async getDetails(@Param('id') id: string) {
    return DataResponse.ok(await this.categoryService.getDetails(id));
  }
}
