import {
  Body, Controller, Post, UsePipes, ValidationPipe
} from '@nestjs/common';

import { DataResponse } from 'src/core';
import { LoginPasswordPayload } from 'src/payloads';
import { AuthService } from 'src/services';

@Controller('/auth/login')
export class LoginController {
  constructor(
    private authService: AuthService
  ) { }

  @Post()
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  async register(
    @Body() payload: LoginPasswordPayload
  ) {
    const res = await this.authService.loginWithPassword(payload);
    return DataResponse.ok(res);
  }
}
