import {
  Controller, Get, Param, Query, UsePipes, ValidationPipe
} from '@nestjs/common';

import { DataResponse } from 'src/core';
import { AdSearchPayload } from 'src/payloads';
import { AdSearchService, AdService } from 'src/services';

@Controller('/ads')
export class AdController {
  constructor(
    private readonly adSearchService: AdSearchService,
    private readonly adService: AdService
  ) { }

  @Get('/search')
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  public async search(@Query() payload: AdSearchPayload) {
    return DataResponse.ok(await this.adSearchService.search(payload));
  }

  @Get('/:id/view')
  @UsePipes(new ValidationPipe({ transform: true, whitelist: true }))
  public async getDetails(@Param('id') id: string) {
    return DataResponse.ok(await this.adService.getDetails(id));
  }
}
