import { join } from 'path';

export default () => ({
  PORT: parseInt(process.env.PORT, 10) || 8000,
  // main database
  MONGODB_URI: process.env.MONGODB_URI || 'mongodb://localhost/xstreamer-v7-dev',

  // ioredis connection config https://github.com/redis/ioredis
  // example redis://:authpassword@127.0.0.1:6380/4 or with username redis://username:authpassword@127.0.0.1:6380/4
  REDIS_QUEUE_CONFIG: {
    port: parseInt(process.env.REDIS_QUEUE_PORT, 10) || 6379, // Redis port
    host: process.env.REDIS_QUEUE_HOST || '127.0.0.1', // Redis host
    username: process.env.REDIS_QUEUE_USERNAME || undefined, // needs Redis >= 6
    password: process.env.REDIS_QUEUE_PASSWORD || undefined,
    db: process.env.REDIS_QUEUE_DB || 0,
    // support tls option in aws memory cache
    tls: process.env.REDIS_QUEUE_TLS ? {} : undefined
  },
  // option to use cluster mode or not.
  REDIS_QUEUE_USE_CLUSTER_MODE: process.env.REDIS_QUEUE_USE_CLUSTER_MODE || false,

  // define width, height of avatar
  AVATAR_SIZE: {
    w: 350,
    h: 350
  },
  TEMPLATE_DIR: join(__dirname, '..', '..', process.env.TEMPLATE_DIR || 'templates'),
  SENDER_EMAIL: process.env.SENDER_EMAIL || 'Support <noreply@example.com>'
});
