const { DB, generateSalt, encryptPassword } = require('../migrations/lib');

const username = 'admin';
const email = `admin@${process.env.DOMAIN || 'example.com'}`;
const password = 'adminadmin';

module.exports = async () => {
  const u = await DB.collection('profiles').findOne({
    $or: [{
      username
    }, {
      email
    }]
  });
  if (u) return;

  const user = await DB.collection('profiles').insertOne({
    name: 'Admin',
    username,
    usernameLowercase: username,
    email,
    roles: ['admin'],
    status: 'active',
    createdAt: new Date(),
    updatedAt: new Date()
  });

  const salt = generateSalt();
  const newVal = encryptPassword(password, salt);
  await DB.collection('auth').insertOne({
    profileId: user.insertedId,
    salt,
    value: newVal,
    type: 'password',
    createdAt: new Date(),
    updatedAt: new Date()
  });
};
