const crypto = require('crypto');

const mongoose = require('mongoose');


exports.COLLECTION = {
  AUTH: 'auth',
  PROFILE: 'profiles',
  SETTING: 'settings',
  EMAIL_TEMPLATE: 'email_templates',
  POST: 'posts',
  CATEGORIES: 'categories',
  VIDEO: 'videos',
  STAT: 'stats'
};

exports.DB = mongoose.connection;

exports.encryptPassword = (pw, salt) => {
  const defaultIterations = 10000;
  const defaultKeyLength = 64;

  return crypto
    .pbkdf2Sync(pw, salt, defaultIterations, defaultKeyLength, 'sha1')
    .toString('base64');
};

exports.generateSalt = (byteSize = 16) => crypto.randomBytes(byteSize).toString('base64');

exports.createSetting = async (setting) => {
  const checkKey = await this.DB.collection(this.COLLECTION.SETTING).findOne({
    key: setting.key
  });
  if (!checkKey) {
    await this.DB.collection(this.COLLECTION.SETTING).insertOne({
      ...setting,
      type: setting.type || 'text',
      createdAt: new Date(),
      updatedAt: new Date()
    });
    // eslint-disable-next-line no-console
    console.log(`Inserted setting: ${setting.key}`);
  } else {
    // eslint-disable-next-line no-console
    console.log(`Setting: ${setting.key} exists`);
  }
};
