const { DB, COLLECTION } = require('./lib');

module.exports.up = async (next) => {
  console.log('Migrate seed stats');
  const videoData = await DB.collection(COLLECTION.VIDEO).aggregate([
    {
      $group: {
        _id: null,
        total: { $sum: 1 },
        active: {
          $sum: {
            $cond: [{ $eq: ['$status', 'active'] }, 1, 0]
          }
        },
        inactive: {
          $sum: {
            $cond: [{ $eq: ['$status', 'inactive'] }, 1, 0]
          }
        },
        waitingVerifed: {
          $sum: {
            $cond: [{ $eq: ['$verified', false] }, 1, 0]
          }
        }
      }
    }
  ]).toArray();

  if (videoData && videoData.length) {
    const {
      total, active, inactive, waitingVerifed
    } = videoData[0];
    await DB.collection(COLLECTION.STAT).updateOne({}, {
      $set: {
        video: {
          waitingVerifed,
          total,
          new: total,
          active,
          inactive
        }
      }
    }, {
      upsert: true
    });
  }

  const videoCategories = await DB.collection(COLLECTION.CATEGORIES).countDocuments({ group: 'video' });
  const members = await DB.collection(COLLECTION.PROFILE).countDocuments({});
  await DB.collection(COLLECTION.STAT).updateOne({}, {
    $set: {
      category: {
        videoCategories
      },
      member: {
        total: members
      }
    }
  }, {
    upsert: true
  });
  console.log('Migrate seed stats done');
  next();
};

module.exports.down = function down(next) {
  next();
};
