const { readFileSync } = require('fs');
const { join } = require('path');

const { replace } = require('lodash');

const { DB, COLLECTION } = require('./lib');

module.exports.up = async function up(next) {
  const regExp = /\[\[DOMAIN\]\]/g;
  const page2257 = readFileSync(join(__dirname, 'content', '2257.html')).toString();
  const pageDMCA = readFileSync(join(__dirname, 'content', 'dmca.html')).toString();
  const pageToS = readFileSync(join(__dirname, 'content', 'tos.html')).toString();

  const [
    page2257Content,
    pageDMCAContent,
    pageToSContent
  ] = await Promise.all([
    replace(page2257, regExp, process.env.DOMAIN),
    replace(pageDMCA, regExp, process.env.DOMAIN),
    replace(pageToS, regExp, process.env.DOMAIN)
  ]);

  const KEYS = {
    TOS: 'terms-of-service',
    USC2257: 'u.s.c-2257',
    DMCA: 'dmca'
  };

  const pages = [
    {
      title: 'TERMS OF SERVICE',
      type: 'post',
      status: 'active',
      seoKeywords: 'tos',
      seoTitle: 'Terms of service',
      seoDesc: 'Terms of service',
      content: pageToSContent,
      slug: KEYS.TOS
    },
    {
      title: 'U.S.C 2257',
      type: 'post',
      status: 'active',
      seoKeywords: 'usc',
      seoTitle: 'U.S.C 2257',
      seoDesc: 'U.S.C 2257',
      content: page2257Content,
      slug: KEYS.USC2257
    },
    {
      title: 'DMCA',
      type: 'post',
      status: 'active',
      seoKeywords: 'dmca',
      seoTitle: 'DMCA',
      seoDesc: 'DMCA',
      content: pageDMCAContent,
      slug: KEYS.DMCA
    }
  ];

  let category = await DB.collection(COLLECTION.CATEGORIES).findOne({ group: 'post', slug: 'information' });
  if (!category) {
    category = await DB.collection(COLLECTION.CATEGORIES).insertOne({
      group: 'post', slug: 'information', title: 'Information', status: 'active', ordering: 0
    });
  }

  // eslint-disable-next-line no-restricted-syntax
  for (const p of pages) {
    // eslint-disable-next-line no-await-in-loop
    const post = await DB.collection(COLLECTION.POST).findOne({ slug: p.slug });
    if (!post) {
      // eslint-disable-next-line no-await-in-loop
      await DB.collection(COLLECTION.POST).insertOne({
        ...p,
        categoryIds: [category.insertedId || category._id],
        createdAt: new Date(),
        updatedAt: new Date()
      });
      // eslint-disable-next-line no-console
      console.log(`Created post ${p.title}`);
    } else {
      // eslint-disable-next-line no-console
      console.log(`Post ${p.title} existed!`);
    }
  }

  next();
};

module.exports.down = function down(next) {
  next();
};
