module.exports = {
  parser: '@typescript-eslint/parser',
  parserOptions: {
    project: 'tsconfig.json',
    tsconfigRootDir: __dirname,
    sourceType: 'module',
  },
  settings: {
    'import/resolver': {
      typescript: {}
    },
  },
  plugins: [
    '@typescript-eslint/eslint-plugin',
    'import'
  ],
  extends: [
    'airbnb-base',
    'airbnb-typescript/base',

    // Extends two more configuration from "import" plugin
    'plugin:import/recommended',
    'plugin:import/typescript'
  ],
  root: true,
  env: {
    node: true,
    jest: true,
  },
  ignorePatterns: ['.eslintrc.js'],
  rules: {
    '@typescript-eslint/interface-name-prefix': 'off',
    '@typescript-eslint/explicit-function-return-type': 'off',
    '@typescript-eslint/explicit-module-boundary-types': 'off',
    '@typescript-eslint/no-explicit-any': 'off',
    'no-unused-vars': 'error',
    '@typescript-eslint/no-unused-vars': 'error',
    'no-underscore-dangle': 0,
    'max-classes-per-file': 0,
    'max-len': 0,
    'max-lines': 0,
    'no-useless-constructor': 0,
    'no-empty-function': 0,
    'comma-dangle': ['error', 'never'],
    '@typescript-eslint/comma-dangle': ['error', 'never'],
    'class-methods-use-this': 0,
    'no-unused-expressions': 0,
    '@typescript-eslint/camelcase': 0,
    'import/prefer-default-export': 0,
    'max-classes-per-file': 0,
    'max-len': 0,
    'max-lines': 0,
    'no-useless-constructor': 0,
    'no-empty-function': 0,
    'class-methods-use-this': 0,
    'no-unused-expressions': 1,
    '@typescript-eslint/camelcase': 0,
    'no-tabs': 1,
    "import/no-unresolved": 0,
    "import/no-cycle": 0,
    'no-multiple-empty-lines': ['error', { max: 2, 'maxEOF': 1 }],
    indent: ['error', 2, {
      'SwitchCase': 1,
      'ignoredNodes': ['PropertyDefinition']
    }],
    '@typescript-eslint/indent': [
      'error',
      2,
      {
        'SwitchCase': 1,
        'ignoredNodes': [
          'PropertyDefinition',
          `FunctionExpression > .params[decorators.length > 0]`,
          `FunctionExpression > .params > :matches(Decorator, :not(:first-child))`,
          `ClassBody.body > PropertyDefinition[decorators.length > 0] > .key`,
        ]
      }
    ],
    quotes: ['error', 'single'],
    // 'import/no-named-as-default-member': 'off',
    'import/order': [
      'error',
      {
        groups: [
          'builtin', // Built-in imports (come from NodeJS native) go first
          'external', // <- External imports
          'internal', // <- Absolute imports
          ['sibling', 'parent'], // <- Relative imports, the sibling and parent types they can be mingled together
          'index', // <- index imports
          'unknown', // <- unknown
        ],
        'newlines-between': 'ignore',
        alphabetize: {
          /* sort in ascending order. Options: ["ignore", "asc", "desc"] */
          order: 'asc',
          /* ignore case. Options: [true, false] */
          caseInsensitive: true,
        },
      },
    ],
    'linebreak-style': ['error', 'unix']
  }
};
